BEGIN TRANSACTION;
CREATE TABLE IF NOT EXISTS `sf_user` (
  `id`	INTEGER PRIMARY KEY AUTOINCREMENT,
  `prenom`	TEXT NOT NULL,
  `nom`	TEXT NOT NULL,
  `email`	TEXT,
  `login`	TEXT NOT NULL,
  `password`	TEXT NOT NULL,
  `profil_id`	INTEGER NOT NULL,
  `admin`	INTEGER NOT NULL DEFAULT 0,
  `connect`	INTEGER NOT NULL DEFAULT 0,
  `etat`	INTEGER NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_sous_module` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `libelle`	text NOT NULL UNIQUE,
  `module_id`	integer NOT NULL,
  `code`	text NOT NULL UNIQUE,
  `etat`	INTEGER NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_profil` (
  `id`	INTEGER PRIMARY KEY AUTOINCREMENT,
  `libelle`	TEXT,
  `etat`	INTEGER NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_module` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `libelle`	text NOT NULL UNIQUE,
  `code`	text NOT NULL UNIQUE,
  `etat`	INTEGER NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_logs` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `action`	text NOT NULL,
  `currenttable`	integer NOT NULL,
  `currentid`	integer NOT NULL,
  `description`	text NOT NULL,
  `datecreation`	timestamp DEFAULT CURRENT_TIMESTAMP,
  `result`	INTEGER NOT NULL,
  `user_id`	integer
);
CREATE TABLE IF NOT EXISTS `sf_droit` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `libelle`	text DEFAULT NULL,
  `espace`	text NOT NULL DEFAULT 'default',
  `sous_module_id`	integer NOT NULL,
  `controller`	text NOT NULL,
  `action`	text NOT NULL,
  `etat`	integer NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_affectation_droit_user` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `affectation_droit_id`	INTEGER NOT NULL,
  `user_id`	INTEGER NOT NULL,
  `etat`	INTEGER NOT NULL DEFAULT 1
);
CREATE TABLE IF NOT EXISTS `sf_affectation_droit` (
  `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `profil_id`	integer NOT NULL,
  `droit_id`	integer NOT NULL,
  `etat`	integer DEFAULT 1
);

INSERT INTO `sf_module` (`id`, `libelle`, `etat`, `code`) VALUES (1, 'Parametrage', 1, 'MA');
INSERT INTO `sf_profil` (`id`, `libelle`, `etat`) VALUES (1, 'Administrateur', 1);
INSERT INTO `sf_sous_module` (`id`, `libelle`, `module_id`, `etat`, `code`) VALUES (1, 'Utilisateur', 1, 1, 'SMA'), (2, 'Profil', 1, 1, 'SMB'), (3, 'Droit', 1, 1, 'SMC'), (4, 'Sous module', 1, 1, 'SMD'), (5, 'Module', 1, 1, 'SME');
INSERT INTO `sf_user` (`id`, `prenom`, `nom`, `email`, `login`, `password`, `profil_id`, `admin`, `connect`, `etat`) VALUES (1,  'admin',  'admin', 'admin@numherit.com',  'admin',  '$2y$09$kU4kDJQAey9gt11iBLFZQenRqFRbWsoiooXjq8nFxHbtLvwpVZ9P6', 1,  1,  0,1);
COMMIT;