<?php
/**
 * Created by PhpStorm.
 * User: Seyni Faye
 * Date: 02/07/2018
 * Time: 11:49
 */

namespace app\webservice;

use app\core\ApiServer;
use app\core\Authorize;
use app\core\TokenJWT;
use \Jacwright\RestServer\RestException;

class Api extends ApiServer
{
    private $model;

    /**
     * Api constructor.
     * @throws RestException
     * @throws \Defuse\Crypto\Exception\BadFormatException
     * @throws \Defuse\Crypto\Exception\EnvironmentIsBrokenException
     */
    public function __construct()
    {
        parent::__construct(__CLASS__);
        $this->model = $this->model("user", "admin");
    }

    use Authorize;


    /**
     * @noAuth
     * @url POST /token
     * @return array
     * @throws \Defuse\Crypto\Exception\BadFormatException
     * @throws \Defuse\Crypto\Exception\EnvironmentIsBrokenException
     */
    public function getToken()
    {
        $param["condition"] = ["login = "=>parent::$paramRequest["login"]];
        $result = $this->model->getUser($param);
        if(count($result['data']) == 0) {
            $result['msg'] = 'Login incorrect';
            $result['error'] = true;
            $result['code'] = 401;
            $result['data'] = $this->params;
            return $this->response($result);
        }
        return (password_verify(parent::$paramRequest['password'], $result['data'][0]->password)) ?
            $this->response(['code'=>200, 'error'=>false, 'data'=>['token'=> TokenJWT::encode($result["data"][0], $this->key_token, [1, "jour"])]]):
            $this->response(['code'=>401, 'error'=>true, 'msg'=>'Mot de passe incorrect']);
    }

    /**
     * @url POST /addUser
     */
    public function insertUser()
    {
        return $this->model->insertUser(parent::$paramRequest);
    }

    /**
     * @url POST /updateUser
     */
    public function updateUser()
    {
        $id = parent::$paramRequest["id"];
        unset(parent::$paramRequest["id"]);
        $param = [
            "champs"=>parent::$paramRequest,
            "condition"=>["id = "=>$id]
        ];
        return $this->model->updateUser($param);
    }

    /**
     * @url GET /deleteUser
     */
    public function deleteUser()
    {
        $param = ["condition"=>["id = "=>parent::$paramRequest["id"]]];
        return $this->model->deleteUser($param);
    }

    /**
     * @url GET /getUser
     */
    public function getUser()
    {
        $param = [];
        if(isset(parent::$paramRequest["id"])) $param["condition"] = ["id = "=>parent::$paramRequest["id"]];
        return $this->model->getUser($param);
    }
}