<form id="validation" class="form-inline form-validator" data-type="update" role="form" action="<?= WEBROOT ?>utilisateur/<?= ((isset($utilisateur->id)) ? "updateUser" : "addUser") ?>" method="post">

    <div class="modal-header">
        <button type="button" class="close" aria-hidden="true" data-dismiss="modal">×</button>
        <h4 class="modal-title"><?= ((isset($utilisateur->id)) ? $this->lang['edit_user'] : $this->lang['new_user']) ?></h4>
    </div>

    <div class="modal-body">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-3"></div>
                <div class="col-sm-6">
                    <div class="form-group" style="width: 100%;padding: 10px;">
                        <label for="profil_id" class="control-label"><?= $this->lang['profil']; ?></label>
                        <select name="profil_id" id="profil_id" class="form-control" style="width: 100%">
                            <?php foreach ($profil as $item) { ?>
                                <option <?= ($utilisateur->profil_id == $item->id) ? "selected" : "" ?> value="<?= $item->id ?>"><?= $item->libelle ?></option>
                            <?php } ?>
                        </select>
                        <span class="help-block with-errors"> </span>
                    </div>
                    <div class="form-group" style="width: 100%;padding: 10px;">
                        <label for="prenom" class="control-label"><?= $this->lang['prenom']; ?></label>
                        <input type="text" id="prenom" name="prenom" class="form-control" placeholder="<?= $this->lang['prenom']; ?>"
                               value="<?= $utilisateur->prenom; ?>" style="width: 100%" required>
                        <span class="help-block with-errors"> </span>
                    </div>
                    <div class="form-group" style="width: 100%;padding: 10px;">
                        <label for="nom" class="control-label"><?= $this->lang['nom']; ?></label>
                        <input type="text" id="nom" name="nom" class="form-control" placeholder="<?= $this->lang['nom']; ?>"
                               value="<?= $utilisateur->nom; ?>" style="width: 100%" required>
                        <span class="help-block with-errors"> </span>
                    </div>
                    <div class="form-group" style="width: 100%;padding: 10px;">
                        <label for="login" class="control-label"><?= $this->lang['login']; ?></label>
                        <input type="text" id="login" name="login" class="form-control" placeholder="<?= $this->lang['login']; ?>"
                               value="<?= $utilisateur->login; ?>" style="width: 100%" required>
                        <span class="help-block with-errors"> </span>
                    </div>
                    <div class="form-group" style="width: 100%;padding: 10px;">
                        <label for="email" class="control-label"><?= $this->lang['email']; ?></label>
                        <input type="email" id="email" name="email" class="form-control" placeholder="<?= $this->lang['email']; ?>"
                               value="<?= $utilisateur->email; ?>" style="width: 100%" required>
                        <span class="help-block with-errors"> </span>
                    </div>
                    <?php if(isset($utilisateur->id)) {  ?> <input type="hidden" name="id" value="<?= $utilisateur->id; ?>"><?php } ?>
                </div>
                <div class="col-sm-3"></div>

            </div>
        </div>
    </div>

    <div class="modal-footer">
        <button class="btn btn-success confirm" data-form="my-form" type="submit"><i class="fa fa-check"></i> <?= $this->lang['valider']; ?>
        </button>
        <button class="btn btn-default" type="button" data-dismiss="modal"><i class="fa fa-times"></i> <?= $this->lang['annuler']; ?> </button>
    </div>

</form>