<?php

/**
 * Created by PhpStorm.
 * User: Seyni FAYE
 * Date: 15/02/2017
 * Time: 21:11
 */

namespace app\controllers\admin;

use app\core\BaseController;
use app\core\Utils;

class UtilisateurController extends BaseController
{
    private $model;

    public function __construct()
    {
        parent::__construct();
        $this->model = $this->model("user");
    }

    /**
     * @droit Lister les utilisateurs - SMA
     */
    public function liste()
    {
        Utils::setUploadFiles($this->paramFILE['fichier'], 'public', 'nom_fichier');
        Utils::setDefaultSort(2, "ASC");
        $this->views->getTemplate();
    }

    /**
     * @throws \Jacwright\RestServer\RestException
     */
    public function listeProcessing()
    {
        $param = [
            "button"=> [
                "modal" => [
                    [["utilisateur/userModal", "utilisateur/updateUser"],"utilisateur/userModal","fa fa-edit"]
                ],
                "default" => [
                    ["champ"=>"etat","val"=>[["utilisateur/activate","fa fa-toggle-off"],["utilisateur/deactivate","fa fa-toggle-on"]]]
                ],
                "custom" => []
            ],
            "tooltip"=> [
                "modal" => [
                    "Modifier"
                ],
                "default" => [
                    ["champ"=>"etat","val"=>["Activer","Desactiver"]]
                ]
            ],
            "classCss"=> [
                "modal" => [],
                "default" => ["confirm"]
            ],
            "attribut"=> [
                "modal" => [],
                "default" => []
            ],
            "args"=>null,
            "dataVal"=>[
                ["champ"=>"etat","val"=>[["<span style='.temp::before{text-align: right;}' class='temp text-info'>Désactiver</span>"],["<span  class='temp text-success' >Activer</span><style>.temp::before{text-align: right;}</style>"]]]
            ],
            "fonction"=>[]
        ];
        if($this->appConfig->profile_level == 2) array_push($param["button"]["default"],["utilisateur/affectation/","fa fa-male"]);
        $this->processing($this->model, "getListeProcess", $param);
    }

    public function userModal()
    {
        if($this->paramGET[0])
            $data['utilisateur'] = $this->model->getUser(["condition"=>["u.id = "=>$this->paramGET[0]]])[0];
        $param = ["table"=>"sf_profil"];
        $data['profil'] = $this->model->get($param);
        $this->views->setData($data);
        $this->modal();
    }

    /**
     * @droit Ajouter un utilisateur - SMA
     */
    public function addUser()
    {
        //parent::validateToken("exemples", "exemples");

        if(Utils::validateMail($this->paramPOST["email"])) {
            $pass = Utils::getGeneratePassword();
            $this->paramPOST['password'] = $pass["crypt"];
            $result = $this->model->insertUser(["champs"=>$this->paramPOST]);
            if($result !== false) {
                $data = [
                    "subject"=>"Création de compte utilisateur",
                    "email"=>$this->paramPOST["email"],
                    "content"=>"template-mail/tpl-user-create",
                    "data"=>[
                        "nom_client"=>$this->paramPOST["prenom"]. " " .$this->paramPOST["nom"],
                        "contenue"=>"veillez vous connecter sur votre compte en cliquant sur ce <a href='".HOST.RACINE."'>lien</a> <br> login: ".$this->paramPOST["email"]."<br> mot de passe: ".$pass["pass"]
                    ]
                ];
//                $this->sendMail($data);
                Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            }
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        else Utils::setMessageALert(["warning", $this->lang['invalide_email']]);
        Utils::redirect("utilisateur", "liste");
    }

    /**
     * @droit Modifier un utilisateur - SMA
     */
    public function updateUser()
    {
        //parent::validateToken("exemples", "exemples");

        $param['condition'] = ["id = "=>$this->paramPOST['id']];
        $param['champs'] = [
            "profil_id"=>$this->paramPOST["profil_id"],
            "prenom"=>$this->paramPOST["prenom"],
            "nom"=>$this->paramPOST["nom"],
            "email"=>$this->paramPOST["email"]
        ];
        $result = $this->model->updateUser($param);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("utilisateur", "liste");
    }

    /**
     * @droit Activer un utilisateur - SMA
     */
    public function activate()
    {
        if(intval($this->paramGET[0]) > 0) {
            $result = $this->model->set(["table" => "sf_user", "champs" => ["etat"=>1],"condition" => ["id = "=>$this->paramGET[0]]]);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        Utils::redirect("utilisateur", "liste");
    }

    /**
     * @droit Désactiver un utilisateur - SMA
     */
    public function deactivate()
    {
        if(intval($this->paramGET[0]) > 0) {
            $result = $this->model->set(["table" => "sf_user", "champs" => ["etat"=>0],"condition" => ["id = "=>$this->paramGET[0]]]);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        Utils::redirect("utilisateur", "liste");
    }

    /**
     * @authorize
     */
    public function affectation()
    {
        $data['idUser'] = $this->paramGET[0];
        $param = [
            "champs" => ["u.id","u.prenom","u.nom","u.email","p.id as idProfil","p.libelle as profil","u.etat"],
            "jointure" => ["INNER JOIN profil p ON u.profil_id = p.id"],
            "condition" => ["u.id = " => $data['idUser']]
        ];
        $result = $this->model->getUser($param);

        if(count($result) == 0) Utils::redirect("utilisateur", "liste");
        else $result = $result[0];

        $data['idProfil'] = $result->idProfil;
        $data['nomProfil'] = $result->profil;
        $param = [
            'table'=>'sf_droit d',
            'champs'=> ['d.id', 'd.libelle as droit', 'sm.libelle as sous_module', 'm.libelle as module', 'd.id AS id_aff', 'd.id AS etat_aff', 'd.id AS id_aff_user', 'd.id AS etat_aff_user'],
            'jointure'=> [
                'INNER JOIN sf_sous_module sm on d.sous_module_id = sm.id',
                'INNER JOIN sf_module m on sm.module_id = m.id',
                'INNER JOIN sf_affectation_droit ad on ad.droit_id = d.id'
            ],
            'condition'=> ['ad.profil_id = '=>$data['idProfil'], 'ad.etat = '=>1]
        ];
        $data['droit'] = $this->model->get($param);
        foreach ($data['droit'] as $key => $droit) {
            $param = [
                'table'=>'sf_affectation_droit',
                'champs'=>['id', 'etat'],
                'condition'=>['profil_id ='=>$this->paramGET[0],'droit_id ='=>$droit->id]
            ];
            $temp = $this->model->get($param);
            $data['droit'][$key]->id_aff = $temp[0]->id;
            $data['droit'][$key]->etat_aff = $temp[0]->etat;

            $param = [
                'table'=>'sf_affectation_droit_user',
                'champs'=>['id', 'etat'],
                'condition'=>['affectation_droit_id ='=>$data['droit'][$key]->id_aff,'user_id ='=>$data['idUser']]
            ];
            $temp = $this->model->get($param);
            $data['droit'][$key]->id_aff_user = $temp[0]->id;
            $data['droit'][$key]->etat_aff_user = $temp[0]->etat;
        }
        $data['droit'] = Utils::setArrayDroit($data['droit'], $this->appConfig->profile_level);
        $this->views->setData($data);
        $this->views->getTemplate();
    }

    /**
     * @droit Affecter les droits des utilisateurs - SMA
     */
    public function addAffectation()
    {
        //parent::validateToken("exemples", "exemples");

        $param = [
            'table'=>'sf_droit d',
            'champs'=>['adu.id'],
            'jointure'=>[
                "INNER JOIN affectation_droit ad ON ad.droit_id = d.id",
                "INNER JOIN affectation_droit_user adu on adu.affectation_droit_id = ad.id"
            ],
            'condition'=>['ad.profil_id ='=>$this->paramPOST['idProfil'],'adu.user_id ='=>$this->paramPOST['idUser'], 'ad.etat ='=>1, 'adu.etat ='=>1]
        ];
        $data['droit'] = $this->model->get($param);

        if (count($this->paramPOST['update'])>0) {
            foreach ($data['droit'] as $item)
                if (!in_array($item->id, $this->paramPOST['update']))
                    $this->model->set(["table" => "sf_affectation_droit_user","champs" => ['etat' => 0],"condition" => ['id =' => $item->id]]);

            foreach ($this->paramPOST['update'] as $item)
                $this->model->set(["table" => "sf_affectation_droit_user","champs" => ['etat' => 1],"condition" => ['id =' => $item]]);

        }
        elseif(count($data['droit'])>0)
            foreach ($data['droit'] as $item)
                $this->model->set(["table" => "sf_affectation_droit_user","champs" => ['etat' => 0],"condition" => ['id =' => $item->id]]);

        if (count($this->paramPOST['add'])>0)
            foreach ($this->paramPOST['add'] as $item)
                $this->model->set(["table" => "sf_affectation_droit_user","champs" => ['affectation_droit_id' => $item, 'user_id' => $this->paramPOST['idUser']]]);

        Utils::redirect("utilisateur", "affectation", [$this->paramPOST['idUser']]);
    }

}