<?php

/**
 * Created by PhpStorm.
 * User: Seyni FAYE
 * Date: 15/02/2017
 * Time: 21:11
 */

namespace app\controllers\admin;

use app\core\BaseController;
use app\core\Session;
use app\core\Utils;

class sousModuleController extends BaseController
{
    private $model;

    public function __construct()
    {
        parent::__construct();
        $this->model = $this->model("sousModule");
    }

    /**
     * @droit Lister les sous modules - SMD
     */
    public function liste()
    {
        $this->views->getTemplate();
    }

    /**
     * @throws \Jacwright\RestServer\RestException
     */
    public function listeProcessing()
    {
        $param = [
            "button"=> [
                "modal" => [
                    ["sousModule/sousModuleModal","sousModule/sousModuleModal","fa fa-edit"]
                ],
                "default" => [
                    ["sousModule/deleteModule/","fa fa-trash"]
                ],
                "custom" => []
            ],
            "tooltip"=> [
                "modal" => [
                    "Modifier"
                ],
                "default" => [
                    "Supprimer"
                ]
            ],
            "classCss"=> [
                "modal" => [],
                "default" => ["confirm"]
            ],
            "attribut"=> [
                "modal" => [],
                "default" => []
            ],
            "args"=>null,
            "dataVal"=>[
                ["champ"=>"etat","val"=>["Désactiver"=>["<span style='.temp::before{text-align: right;}' class='temp text-info'>Désactiver</span>"],"Activer"=>["<span  class='temp text-success' >Activer</span><style>.temp::before{text-align: right;}</style>"]]]
            ],
            "fonction"=>[]
        ];
        $this->processing($this->model, "getListeProcess", $param);
    }

    public function sousModuleModal()
    {
        if($this->paramGET[0])
            $data['sousModule'] = $this->model->getSousModule(["condition"=>["id = "=>$this->paramGET[0]]])[0];
        $data['module'] = $this->model->get(["table"=>"sf_module"]);
        $this->views->setData($data);
        $this->modal();
    }

    /**
     * @droit Ajouter un sous module - SMD
     */
    public function addSousModule()
    {
        //parent::validateToken("exemples", "exemples");

        $result = $this->model->insertSousModule(["champs"=>$this->paramPOST]);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("sousModule", "liste");
    }

    /**
     * @droit Modifier un sous module - SMD
     */
    public function updateSousModule()
    {
        //parent::validateToken("exemples", "exemples");

        $param['condition'] = ["id = "=>$this->paramPOST['id']];
        $param['champs'] = [
            "module_id"=>$this->paramPOST["module_id"],
            "libelle"=>$this->paramPOST["sous_module"],
            "code"=>$this->paramPOST["code"]
        ];
        $result = $this->model->updateSousModule($param);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("sousModule", "liste");
    }

    /**
     * @droit Supprimer un sous module - SMD
     */
    public function deleteSousModule()
    {
        //parent::validateToken("exemples", "exemples");

        if(isset($this->paramGET[0])) {
            $param['condition'] = ["id = "=>$this->paramGET[0]];
            $result = $this->model->deleteSousModule($param);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("sousModule", "liste");
    }
}