<?php

/**
 * Created by PhpStorm.
 * User: Seyni FAYE
 * Date: 15/02/2017
 * Time: 21:11
 */

namespace app\controllers\admin;

use app\core\BaseController;
use app\core\Session;
use app\core\Utils;

class ProfilController extends BaseController
{
    private $model;

    public function __construct()
    {
        parent::__construct();
        $this->model = $this->model("profil");
    }

    /**
     * @droit Lister les profils - SMB
     */
    public function liste()
    {
        $this->views->getTemplate();
    }

    /**
     * @throws \Jacwright\RestServer\RestException
     */
    public function listeProcessing()
    {
        $param = [
            "button"=> [
                "modal" => [
                    [["profil/profilModal","utilisateur/updateProfil"],"profil/profilModal","fa fa-edit"]
                ],
                "default" => [
                    ["champ"=>"etat","val"=>[["profil/activate","fa fa-toggle-off"],["profil/deactivate","fa fa-toggle-on"]]],
                    ["profil/affectation","fa fa-male"],
                    ["profil/deleteProfil","fa fa-trash"]
                ],
                "custom" => []
            ],
            "tooltip"=> [
                "modal" => [
                    "Modifier"
                ],
                "default" => [
                    ["champ"=>"etat","val"=>["Activer","Desactiver"]],
                    "Affectation",
                    "Supprimer"
                ]
            ],
            "classCss"=> [
                "modal" => [],
                "default" => ["confirm",null,"confirm"]
            ],
            "attribut"=> [
                "modal" => [],
                "default" => []
            ],
            "args"=>null,
            "dataVal"=>[
                ["champ"=>"etat","val"=>[["<span style='.temp::before{text-align: right;}' class='temp text-info'>Désactiver</span>"],["<span  class='temp text-success' >Activer</span><style>.temp::before{text-align: right;}</style>"]]]
            ],
            "fonction"=>[]
        ];
        $this->processing($this->model, "getListeProcess", $param);
    }

    public function affectation()
    {
        $data['idProfil'] = $this->paramGET[0];
        $param = ["condition" => ["id = " => $this->paramGET[0]]];
        $result = $this->model->getProfil($param);

        if(count($result) == 0) Utils::redirect("profil", "liste");
        else $result = $result[0];

        $data['nomProfil'] = $result->profil;
        $param = [
            'table'=>'sf_droit d',
            'champs'=>['d.id', 'd.libelle as droit', 'sm.libelle as sous_module', 'm.libelle as module', 'd.id AS id_aff', 'd.id AS etat_aff'],
            'jointure'=> [
                'INNER JOIN sf_sous_module sm on d.sous_module_id = sm.id',
                'INNER JOIN sf_module m on sm.module_id = m.id'
            ]
        ];
        $data['droit'] = $this->model->get($param);

        foreach ($data['droit'] as $key => $droit) {
            $param = [
                'table'=>'sf_affectation_droit',
                'champs'=>['id', 'etat'],
                'condition'=>['profil_id ='=>$this->paramGET[0],'droit_id ='=>$droit->id]
            ];
            $temp = $this->model->get($param);

            $data['droit'][$key]->id_aff = $temp[0]->id;
            $data['droit'][$key]->etat_aff = $temp[0]->etat;
        }
        $data['droit'] = Utils::setArrayDroit($data['droit']);
        $this->views->setData($data);
        $this->views->getTemplate();
    }

    public function profilModal()
    {
        if($this->paramGET[0]) {
            $data['profil'] = $this->model->getProfil(["condition"=>["id = "=>$this->paramGET[0]]])[0];
            $this->views->setData($data);
        }
        $this->modal();
    }

    /**
     * @droit Ajouter un profil - SMB
     */
    public function addProfil()
    {
        //parent::validateToken("exemples", "exemples");

        $result = $this->model->insertProfil(["champs"=>$this->paramPOST]);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("profil", "liste");
    }

    /**
     * @droit Activer un profil - SMB
     */
    public function activate()
    {
        if(intval($this->paramGET[0]) > 0) {
            $result = $this->model->set(["table" => "sf_profil", "champs" => ["etat"=>1],"condition" => ["id = "=>$this->paramGET[0]]]);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        Utils::redirect("profil", "liste");
    }

    /**
     * @droit Désactiver un profil - SMB
     */
    public function deactivate()
    {
        if(intval($this->paramGET[0]) > 0) {
            $result = $this->model->set(["table" => "sf_profil", "champs" => ["etat"=>0],"condition" => ["id = "=>$this->paramGET[0]]]);
            if($result !== false) Utils::setMessageALert(["success","Utilisateur desactivé avec succes"]);
            else Utils::setMessageALert(["danger","Echec de la desactivation de l'utilisateur"]);
        }
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        Utils::redirect("profil", "liste");
    }

    /**
     * @droit Affecter les droits des profils - SMB
     */
    public function addAffectation()
    {
        //parent::validateToken("exemples", "exemples");

        $param = [
            'table'=>'sf_droit d',
            'champs'=>['ad.id'],
            'jointure'=>["INNER JOIN sf_affectation_droit ad ON ad.droit_id = d.id"],
            'condition'=>['ad.profil_id ='=>$this->paramPOST['idProfil'], 'ad.etat ='=>1]
        ];
        $data['droit'] = $this->model->get($param);
        if (count($this->paramPOST['update'])>0) {
            foreach ($data['droit'] as $item)
                if (!in_array($item->id, $this->paramPOST['update']))
                    $this->model->set(["table" => "sf_affectation_droit","champs" => ['etat' => 0],"condition" => ['id =' => $item->id]]);

            foreach ($this->paramPOST['update'] as $item)
                $this->model->set(["table" => "sf_affectation_droit","champs" => ['etat' => 1],"condition" => ['id =' => $item]]);

        }elseif(count($data['droit'])>0)
            foreach ($data['droit'] as $item)
                $this->model->set(["table" => "sf_affectation_droit","champs" => ['etat' => 0],"condition" => ['id =' => $item->id]]);

        if (count($this->paramPOST['add'])>0)
            foreach ($this->paramPOST['add'] as $item)
                $this->model->set(["table" => "sf_affectation_droit","champs" => ['profil_id' => $this->paramPOST['idProfil'], 'droit_id' => $item]]);

        Utils::redirect("profil", "affectation", [$this->paramPOST['idProfil']]);
    }

    /**
     * @droit Modifier un profil - SMB
     */
    public function updateProfil()
    {
        //parent::validateToken("exemples", "exemples");

        $param['condition'] = ["id = "=>$this->paramPOST['id']];
        $param['champs'] = ["libelle ="=>$this->paramPOST["profil"]];
        $result = $this->model->updateProfil($param);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("profil", "liste");
    }

    /**
     * @droit Supprimer un profil - SMB
     */
    public function deleteProfil()
    {
        //parent::validateToken("exemples", "exemples");

        if(isset($this->paramGET[0])) {
            $param['condition'] = ["id = "=>$this->paramGET[0]];
            $result = $this->model->deleteProfil($param);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("profil", "liste");
    }
}