<?php

/**
 * Created by PhpStorm.
 * User: Seyni FAYE
 * Date: 15/02/2017
 * Time: 21:11
 */

namespace app\controllers\admin;

use app\core\BaseController;
use app\core\Session;
use app\core\Utils;

class ModuleController extends BaseController
{
    private $model;

    public function __construct()
    {
        parent::__construct();
        $this->model = $this->model("module");
    }

    /**
     * @droit Lister les modules - SME
     */
    public function liste()
    {
        $this->views->getTemplate();
    }

    /**
     * @throws \Jacwright\RestServer\RestException
     */
    public function listeProcessing()
    {
        $param = [
            "button"=> [
                "modal" => [
                    ["module/moduleModal","module/moduleModal","fa fa-edit"]
                ],
                "default" => [
                    ["module/deleteModule/","fa fa-trash"]
                ],
                "custom" => []
            ],
            "tooltip"=> [
                "modal" => [
                    "Modifier"
                ],
                "default" => [
                    "Supprimer"
                ]
            ],
            "classCss"=> [
                "modal" => [],
                "default" => ["confirm"]
            ],
            "attribut"=> [
                "modal" => [],
                "default" => []
            ],
            "args"=>null,
            "dataVal"=>[
                ["champ"=>"etat","val"=>["Désactiver"=>["<span style='.temp::before{text-align: right;}' class='temp text-info'>Désactiver</span>"],"Activer"=>["<span  class='temp text-success' >Activer</span><style>.temp::before{text-align: right;}</style>"]]]
            ],
            "fonction"=>[]
        ];
        $this->processing($this->model, "getListeProcess", $param);
    }

    public function moduleModal()
    {
        if($this->paramGET[0]){
            $data['module'] = $this->model->getModule(["condition"=>["id = "=>$this->paramGET[0]]])[0];
            $this->views->setData($data);
        }
        $this->modal();
    }

    /**
     * @droit Ajouter un module - SME
     */
    public function addModule()
    {
        if(isset($this->paramPOST["module"])) {
            $result = $this->model->insertModule(["champs"=>$this->paramPOST]);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("module", "liste");
    }

    /**
     * @droit Modifier un module - SME
     */
    public function updateModule()
    {
        if(isset($this->paramPOST["libelle"])) {
            $param['condition'] = ["id = "=>$this->paramPOST['id']];
            $param['champs'] = [
                "libelle"=>$this->paramPOST["libelle"],
                "code"=>$this->paramPOST["code"]
            ];
            $result = $this->model->updateModule($param);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("module", "liste");
    }

    /**
     * @droit Supprimer un module - SME
     */
    public function deleteModule()
    {
        if(isset($this->paramGET[0])) {
            $param['condition'] = ["id = "=>$this->paramGET[0]];
            $result = $this->model->deleteModule($param);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("module", "liste");
    }
}