<?php

/**
 * Created by PhpStorm.
 * User: Seyni FAYE
 * Date: 15/02/2017
 * Time: 21:11
 */

namespace app\controllers\admin;

use app\core\BaseController;
use app\core\Utils;

class DroitController extends BaseController
{
    private $model;

    public function __construct()
    {
        parent::__construct();
        $this->model = $this->model("droit");
    }

    /**
     * @droit Lister les droits - SMC
     */
    public function liste()
    {
        Utils::setDefaultSort(2, "ASC");
        $this->views->getTemplate();
    }

    /**
     * @throws \Jacwright\RestServer\RestException
     */
    public function listeProcessing()
    {
        $param = [
            "button"=> [
                "modal" => [],
                "default" => [
                    ["champ"=>"etat","val"=>[["utilisateur/activate","fa fa-toggle-off"],["utilisateur/deactivate","fa fa-toggle-on"]]],
                    ["droit/deleteDroit/","fa fa-trash"]
                ],
                "custom" => []
            ],
            "tooltip"=> [
                "modal" => [
                    "Modifier"
                ],
                "default" => [
                    ["champ"=>"etat","val"=>["Activer","Desactiver"]],
                    "Supprimer"
                ]
            ],
            "classCss"=> [
                "modal" => [],
                "default" => ["confirm","confirm"]
            ],
            "attribut"=> [
                "modal" => [],
                "default" => []
            ],
            "args"=>null,
            "dataVal"=>[
                ["champ"=>"etat","val"=>[["<span style='.temp::before{text-align: right;}' class='temp text-info'>Désactiver</span>"],["<span  class='temp text-success' >Activer</span><style>.temp::before{text-align: right;}</style>"]]]
            ],
            "fonction"=>[]
        ];
        $this->processing($this->model, "getListeProcess", $param);
    }

    public function droitModal()
    {
        if($this->paramGET[2]) $data['droit'] = $this->model->getDroit(["condition"=>["id = "=>$this->paramGET[2]]])[0];
        $data['sousModule'] = $this->model->get(["table"=>"sf_sous_module"]);
        $this->views->setData($data);
        $this->modal();
    }

    /**
     * @droit Modifier un droit - SMC
     */
    public function updateDroit()
    {
        //parent::validateToken("exemples", "exemples");

        $param['condition'] = ["id = "=>$this->paramPOST['id']];
        $param['champs'] = [
            "libelle ="=>$this->paramPOST["droit"],
            "sous_module_id ="=>$this->paramPOST["sous_module_id"],
            "controller ="=>$this->paramPOST["controller"],
            "action ="=>$this->paramPOST["action"]
        ];
        $result = $this->model->updateDroit($param);
        if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
        else Utils::setMessageALert(["error",$this->lang["actionechec"]]);

        Utils::redirect("droit", "liste");
    }

    /**
     * @droit Supprimer un droit - SMC
     */
    public function deleteDroit()
    {
        //parent::validateToken("exemples", "exemples");

        if(isset($this->paramGET[0])) {
            $param['condition'] = ["id = "=>$this->paramGET[0]];
            $result = $this->model->deleteDroit($param);
            if($result !== false) Utils::setMessageALert(["success",$this->lang["actionsuccess"]]);
            else Utils::setMessageALert(["error",$this->lang["actionechec"]]);
        }
        Utils::redirect("droit", "liste");
    }
}